/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.events.thebeyond;

import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.cards.colorless.Madness;
import com.megacrit.cardcrawl.cards.curses.Writhe;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.AbstractImageEvent;
import com.megacrit.cardcrawl.events.GenericEventDialog;
import com.megacrit.cardcrawl.helpers.CardLibrary;
import com.megacrit.cardcrawl.localization.EventStrings;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import com.megacrit.cardcrawl.vfx.cardManip.ShowCardAndObtainEffect;

public class WindingHalls
extends AbstractImageEvent {
    public static final String ID = "Winding Halls";
    private static final EventStrings eventStrings = CardCrawlGame.languagePack.getEventString("Winding Halls");
    public static final String NAME = WindingHalls.eventStrings.NAME;
    public static final String[] DESCRIPTIONS = WindingHalls.eventStrings.DESCRIPTIONS;
    public static final String[] OPTIONS = WindingHalls.eventStrings.OPTIONS;
    private int HP_LOSS = 10;
    private static final float HEAL_AMT = 0.25f;
    private static final String INTRO_BODY1 = DESCRIPTIONS[0];
    private static final String INTRO_BODY2 = DESCRIPTIONS[1];
    private static final String CHOICE_1_TEXT = DESCRIPTIONS[2];
    private static final String CHOICE_2_TEXT = DESCRIPTIONS[3];
    private int screenNum = 0;

    public WindingHalls() {
        super(NAME, INTRO_BODY1, "images/events/winding.jpg");
        GenericEventDialog.setDialogOption(OPTIONS[0]);
    }

    @Override
    protected void buttonEffect(int buttonPressed) {
        block0 : switch (this.screenNum) {
            case 0: {
                GenericEventDialog.updateBodyText(INTRO_BODY2);
                this.screenNum = 1;
                GenericEventDialog.updateDialogOption(0, OPTIONS[1], CardLibrary.getCopy("Madness"));
                GenericEventDialog.setDialogOption(OPTIONS[2] + (int)((float)AbstractDungeon.player.maxHealth * 0.25f) + OPTIONS[4], CardLibrary.getCopy("Writhe"));
                break;
            }
            case 1: {
                switch (buttonPressed) {
                    case 0: {
                        this.logMetric("Embrace Madness");
                        GenericEventDialog.updateBodyText(CHOICE_1_TEXT);
                        AbstractDungeon.player.damage(new DamageInfo(null, this.HP_LOSS));
                        CardCrawlGame.sound.play("ATTACK_MAGIC_SLOW_1");
                        AbstractDungeon.effectList.add(new ShowCardAndObtainEffect(new Madness(), (float)Settings.WIDTH / 2.0f - 350.0f * Settings.scale, (float)Settings.HEIGHT / 2.0f));
                        AbstractDungeon.effectList.add(new ShowCardAndObtainEffect(new Madness(), (float)Settings.WIDTH / 2.0f + 350.0f * Settings.scale, (float)Settings.HEIGHT / 2.0f));
                        UnlockTracker.markCardAsSeen("Madness");
                        this.screenNum = 2;
                        GenericEventDialog.updateDialogOption(0, OPTIONS[3]);
                        GenericEventDialog.clearRemainingOptions();
                        break block0;
                    }
                    case 1: {
                        GenericEventDialog.updateBodyText(CHOICE_2_TEXT);
                        AbstractDungeon.player.heal((int)((float)AbstractDungeon.player.maxHealth * 0.25f));
                        AbstractDungeon.effectList.add(new ShowCardAndObtainEffect(new Writhe(), (float)Settings.WIDTH / 2.0f + 10.0f * Settings.scale, (float)Settings.HEIGHT / 2.0f));
                        UnlockTracker.markCardAsSeen("Writhe");
                        this.logMetric("Writhe");
                        this.screenNum = 2;
                        GenericEventDialog.updateDialogOption(0, OPTIONS[3]);
                        GenericEventDialog.clearRemainingOptions();
                        break block0;
                    }
                }
                break;
            }
            default: {
                this.openMap();
            }
        }
    }

    public void logMetric(String actionTaken) {
        AbstractEvent.logMetric(ID, actionTaken);
    }
}

